<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
//mpesa
Route::post('validation', [App\Http\Controllers\MpesaTransactionController::class, 'validation']);
Route::post('confirmation', [App\Http\Controllers\MpesaTransactionController::class, 'confirmation_url']); 
Route::post('queue_timeout_url', [App\Http\Controllers\MpesaTransactionController::class, 'queue_timeout_url']); 
Route::post('result_url', [App\Http\Controllers\MpesaTransactionController::class, 'result_url']); 
Route::get('accesstoken', [App\Http\Controllers\MpesaTransactionController::class, 'get_access_token']);
Route::get('b2caccesstoken', [App\Http\Controllers\MpesaTransactionController::class, 'getB2C_access_token']); 
Route::post('send_loan', [App\Http\Controllers\MpesaTransactionController::class, 'send_loan']); 

Route::post('stkpush', [App\Http\Controllers\MpesaTransactionController::class, 'customerMpesaSTKPush']);
Route::get('/mpesatransactions/fetch', [App\Http\Controllers\MpesaTransactionController::class, 'show'])->name('fetch');
Route::post('/mpesatransactions/confirmation', [App\Http\Controllers\MpesaTransactionController::class, 'Pullconfirmation']);